dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 6, 220, 250, "assets/images/table/cruise_6", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 4, 260, 400, "assets/images/table/cruise", "assets/images/food/item_mark2", "R" );

useFloAsServer = 0;
useWineTable = 1;
numMoodBoosts = 2;
numServers = 1;
maxCoupleHappiness = 200;

-- Group 1
guest = LManager.GenGuest(female02);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + female02;
guest.percentRequestDrink = 70;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = NOT_GUEST + female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = male01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 4, 3000);


-- Group 2


guest = LManager.GenGuest(aunt);
guest.matchType = female03;
guest.percentRequestTissue = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = female03;
guest.percentRequestCoffee = 50;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = aunt;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(5, 8, 24000);

-- Group 3

guest = LManager.GenGuest(male02);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table2;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(9, 10, 65000);


-- Group 4

guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + female02;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = male01;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(11, 13, 90000);

-- Group 5

guest = LManager.GenGuest(male02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(14, 15, 120000);

-- Group 6

guest = LManager.GenGuest(female02);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female04;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(16, 18, 150000);


LManager:AdjustGuestTolerance(130);

LManager:SetLevelSetting ("dogDelay", 70000); 
LManager:SetLevelSetting ("dogChance", 100);

LManager:SetLevelSetting ("speakerDelay", 155000); 
LManager:SetLevelSetting ("speakerChance", 100);

LManager:AddQuinnEvent( "fx/fx_chef_table_fire.lua", 660, 155, 110000 );


-- Set up the Level Settings
LManager:SetLevelNumber(3,5);
LManager:SetLevelScores(7000, 10000);
LManager:SetLevelTime(300000);

LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 1.ogg","assets/audio/music/Disco Dance 1.ogg","assets/audio/music/new_dance_4.ogg");
LManager:SetBackgroundImage("assets/images/bg_cruise");
LManager:SetChairImage("assets/images/table/chair03");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );